/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.install.commons.base.driver.common.Cloner;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.WinHelper;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiix.OiixNetOps;

public class OracleCloner
extends Cloner {
    public static final String APPLICATION_CONFIG = "/oracle/install/ivw/common/util/clone-application-config.xml";
    private Logger logger = Logger.getLogger(OracleCloner.class.getName());

    protected void processArguments(List<String> args) throws IllegalArgumentException {
        this.setUIType(UIType.NONE);
        this.validateArguments(args);
        super.processArguments(args);
    }

    public OracleCloner() {
        this.init();
    }

    protected void init() {
        SetupDriver.registerDriver((String)"oracle.install.driver.oui.OUICloneDriver");
    }

    public void startup(String ... args) {
        try {
            super.startup(APPLICATION_CONFIG, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.SEVERE, e.getMessage());
        }
    }

    public void validateArguments(List<String> args) {
        StatusMessages messages = new StatusMessages();
        HashMap<String, String> commandLineArgsMap = new HashMap<String, String>();
        for (String argument : args) {
            String[] parameter;
            if (argument.indexOf("=") <= 0 || (parameter = argument.split("=")) == null) continue;
            if (parameter.length == 1) {
                commandLineArgsMap.put(parameter[0], "");
                continue;
            }
            commandLineArgsMap.put(parameter[0], parameter[1]);
        }
        String oracleHome = (String)commandLineArgsMap.get("ORACLE_HOME");
        String oracleBase = (String)commandLineArgsMap.get("ORACLE_BASE");
        String oracleServiceUserName = (String)commandLineArgsMap.get("ORACLE_HOME_USER");
        String localNodeName = OiixNetOps.getMachineName((String)PlatformInfo.getInstance().getFullHostName());
        String clusterNodesSpecified = (String)commandLineArgsMap.get("CLUSTER_NODES");
        if (clusterNodesSpecified != null && !clusterNodesSpecified.toLowerCase().contains(localNodeName.toLowerCase())) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.CLONE_LOCAL_NODE_NOT_PASSED, new Object[0]));
        }
        if (clusterNodesSpecified != null) {
            String[] clusterNodes = clusterNodesSpecified.substring(1, clusterNodesSpecified.length() - 1).split(",");
            ArrayList<String> invalidNodes = new ArrayList<String>();
            for (int i = 0; i < clusterNodes.length; ++i) {
                try {
                    String ipAddress = MachineInfo.getInstance().getIPAddressForHostName(clusterNodes[i]);
                    continue;
                }
                catch (UnknownHostException e) {
                    this.logger.log(Level.INFO, "Cluster Node :(" + clusterNodes[i] + ")is not resolvable to a ip address");
                    invalidNodes.add(clusterNodes[i]);
                }
            }
            if (invalidNodes.size() > 0) {
                messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.CLONE_CLUSTER_NODE_PASSED_NOT_VALID, new Object[]{invalidNodes}));
            }
        }
        if (PlatformInfo.getInstance().isWindows()) {
            boolean exists;
            if (oracleHome != null && oracleHome.length() > 0 && oracleServiceUserName != null && oracleServiceUserName.length() > 0) {
                Version m_version = new Version();
                try {
                    Credentials m_cred = new Credentials(oracleServiceUserName);
                    WinSecurityFactory m_winSecFactory = WinSecurityFactory.getInstance((String)(oracleHome + File.separator + "bin"), null);
                    User m_user = m_winSecFactory.getUser(m_cred, m_version);
                    if (!m_user.isExists()) {
                        messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_SPECIFIED_USER_DOESNOT_EXISTS, new Object[0]));
                    }
                }
                catch (WindowsSecurityException e) {
                    this.logger.log(Level.INFO, "Error while checking for the user existence during clone", e);
                }
            }
            if (oracleBase != null && oracleBase.length() > 0 && oracleServiceUserName != null && oracleServiceUserName.length() > 0 && !oracleServiceUserName.equals(Credentials.BuiltinUser.LOCALSYSTEM.toString()) && !oracleServiceUserName.equals(Credentials.BuiltinUser.LOCALSERVICE.toString()) && (exists = new File(oracleBase).exists())) {
                WinHelper WinHelper2 = new WinHelper();
                if (!WinHelper.userOwnsSpecifiedBase(oracleServiceUserName, oracleBase, false)) {
                    messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOME_USER_NOT_OWNER_OF_SPECIFIED_OB, new Object[0]));
                }
            }
        }
        if (messages.size() > 0) {
            ExceptionManager.advise((StatusMessages)messages);
            this.shutdown((ExitStatus)OUIExitStatus.VAR_VALIDATION_FAILURE);
        }
    }

    public static void main(String[] args) {
        try {
            OracleCloner oracleCloner = (OracleCloner)Application.getInstance(OracleCloner.class);
            PlatformInfo platInfo = PlatformInfo.getInstance();
            if (!platInfo.isWindows()) {
                oracleCloner.startup(args);
            } else {
                boolean isLocalSystem = true;
                ArrayList<String> argList = new ArrayList<String>();
                if (args != null) {
                    for (int index = 0; index < args.length; ++index) {
                        String tempArg;
                        if (args[index].startsWith("ORACLE_SERVICE_USER")) {
                            tempArg = null;
                            String[] temp = args[index].split("=");
                            tempArg = "oracle_install_OracleHomeUserName=" + temp[1];
                            isLocalSystem = false;
                            argList.add(tempArg);
                        }
                        if (args[index].startsWith("ORACLE_BASE")) {
                            tempArg = null;
                            String[] ob = args[index].split("=");
                            tempArg = "oracle_install_isExistingBase=" + OFAWrapper.getInstance().isExistingBase(ob[1]);
                            System.out.println(tempArg);
                            argList.add(tempArg);
                            argList.add(args[index]);
                        }
                        argList.add(args[index]);
                    }
                }
                if (isLocalSystem) {
                    argList.add("oracle_install_OracleHomeUserName=" + Credentials.BuiltinUser.LOCALSYSTEM.toString());
                    argList.add("oracle_install_IsOracleServiceUserExists=true");
                    argList.add("oracle_install_IsBuiltInAccount=true");
                    argList.add("oracle_install_OracleSVCUserPWDReq=false");
                } else {
                    argList.add("oracle_install_IsOracleServiceUserExists=true");
                    argList.add("oracle_install_IsBuiltInAccount=false");
                    argList.add("oracle_install_OracleSVCUserPWDReq=true");
                }
                String localUser = System.getProperty("user.name");
                String domainUser = null;
                if (System.getenv("USERDOMAIN") != null) {
                    domainUser = System.getenv("USERDOMAIN") + "\\" + System.getProperty("user.name");
                }
                if (domainUser != null && WinHelper.isDomainUser(domainUser, "")) {
                    argList.add("oracle_install_installUser=" + domainUser);
                } else {
                    argList.add("oracle_install_installUser=" + localUser);
                }
                String[] argCopy = argList.toArray(new String[0]);
                oracleCloner.startup(argCopy);
            }
        }
        catch (Exception e) {
            ExceptionManager.handle((Throwable)e);
        }
    }
}

